package ru.yandex.travel.orders.services;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix = "url-shortener", ignoreUnknownFields = false)
@Data
@Validated
public class UrlShortenerConfigurationProperties {
    @NotEmpty
    private String baseUrl;
    @NotNull
    private Duration timeout;
}
