package ru.yandex.travel.orders.services;

import java.util.List;
import java.util.stream.Collectors;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.admin.proto.TAdminVoucherInfo;
import ru.yandex.travel.orders.commons.proto.ESnippet;
import ru.yandex.travel.orders.entities.Voucher;

@Service
@Slf4j
@RequiredArgsConstructor
public class VoucherInfoMapper {

    public List<TAdminVoucherInfo> getVouchersInfoFor(List<Voucher> vouchers, List<ESnippet> snippets) {
        boolean showPrivateInfo = snippets.contains(ESnippet.S_PRIVATE_INFO);
        return vouchers.stream()
                .map(v -> buildVoucherInfoFor(v, showPrivateInfo).build())
                .collect(Collectors.toList());
    }

    private TAdminVoucherInfo.Builder buildVoucherInfoFor(Voucher voucher, boolean showPrivateInfo) {
        Preconditions.checkNotNull(voucher, "Voucher should not be null");

        TAdminVoucherInfo.Builder voucherBuilder = TAdminVoucherInfo.newBuilder();
        voucherBuilder.setId(Strings.nullToEmpty(voucher.getId().toString()));
        voucherBuilder.setName(Strings.nullToEmpty(voucher.getVoucherName()));

        if (showPrivateInfo) {
            voucherBuilder.setUrl(Strings.nullToEmpty(voucher.getVoucherUrl()));
        }

        return voucherBuilder;
    }
}
