package ru.yandex.travel.orders.services;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix = "yasms", ignoreUnknownFields = false)
@Data
@Validated
public class YaSmsConfigurationProperties {
    @NotEmpty
    private String sender;
    @NotEmpty
    private String baseUrl;
    @NotNull
    private Duration timeout;
    @NotEmpty
    private String tvmAlias;

    private IgnoreConfig ignore = new IgnoreConfig();

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class IgnoreConfig {
        private IgnoreMode mode = IgnoreMode.NONE;
        private List<String> phones = new ArrayList<>();
    }

    public enum IgnoreMode {
        WHITE_LIST,
        BLACK_LIST,
        NONE,
    }
}
