package ru.yandex.travel.orders.services;

public class YaSmsServiceException extends RuntimeException {
    private static final String BAD_PHONE_CODE = "BADPHONE";
    private static final String LIMIT_EXCEEDED_CODE = "LIMITEXCEEDED";
    private static final int TOO_LARGE_HTTP_STATUS_CODE = 414;

    private String errorCode;
    private Integer httpStatusCode;

    public YaSmsServiceException(String message, int httpStatusCode) {
        super(message);
        this.httpStatusCode = httpStatusCode;
    }

    public YaSmsServiceException(String message) {
        super(message);
    }

    public YaSmsServiceException(String message, Throwable cause) {
        super(message, cause);
    }

    public YaSmsServiceException(String errorCode, String errorMsg) {
        super(String.format("YaSms error. Code %s. Message %s.", errorCode, errorMsg));
        this.errorCode = errorCode;
    }

    public boolean isBadPhoneError() {
        return BAD_PHONE_CODE.equals(errorCode);
    }

    public boolean isLimitExceededError() {
        return LIMIT_EXCEEDED_CODE.equals(errorCode);
    }

    public boolean isTooLargeError() {
        return httpStatusCode != null && TOO_LARGE_HTTP_STATUS_CODE == httpStatusCode;
    }
}
