package ru.yandex.travel.orders.services.attachments;

import java.util.Map;

import com.google.common.collect.ImmutableMap;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.notifications.Attachment;
import ru.yandex.travel.orders.entities.notifications.AttachmentProviderType;
import ru.yandex.travel.orders.services.cloud.s3.InMemoryS3Object;
import ru.yandex.travel.orders.services.cloud.s3.S3Service;

import static ru.yandex.travel.orders.entities.notifications.AttachmentProviderType.FISCAL_RECEIPT;
import static ru.yandex.travel.orders.entities.notifications.AttachmentProviderType.HOTEL_ACCOUNTING_ACT;
import static ru.yandex.travel.orders.entities.notifications.AttachmentProviderType.HOTEL_BOOKING_REPORT;
import static ru.yandex.travel.orders.entities.notifications.AttachmentProviderType.HOTEL_PAYOUT_REPORT;
import static ru.yandex.travel.orders.entities.notifications.AttachmentProviderType.IM;
import static ru.yandex.travel.orders.entities.notifications.AttachmentProviderType.MOVISTA_COUPON;
import static ru.yandex.travel.orders.entities.notifications.AttachmentProviderType.SUBURBAN_COUPON;
import static ru.yandex.travel.orders.entities.notifications.AttachmentProviderType.URL;

@Slf4j
public class AttachmentsHelper {
    private static final Map<AttachmentProviderType, String> PROVIDER_2_FOLDER =
            ImmutableMap.<AttachmentProviderType, String>builder()
                    .put(FISCAL_RECEIPT, "fiscal_receipts")
                    .put(URL, "hotel_vouchers")
                    .put(IM, "im_vouchers")
                    .put(SUBURBAN_COUPON, "suburban_coupons")
                    .put(MOVISTA_COUPON, "movista_coupons")
                    .put(HOTEL_BOOKING_REPORT, "hotel_booking_reports")
                    .put(HOTEL_PAYOUT_REPORT, "hotel_payout_reports")
                    .put(HOTEL_ACCOUNTING_ACT, "hotel_accounting_acts")
                    .build();

    public static void storeAttachmentData(Attachment attachment, byte[] data, S3Service s3Service) {
        String id = "attachments/" + getProviderFolder(attachment)
                + "/" + attachment.getFilename() + "." + attachment.getId();
        s3Service.uploadObject(InMemoryS3Object.builder()
                .id(id)
                .mimeType(attachment.getMimeType())
                .fileName(attachment.getFilename())
                .data(data)
                .build());
        attachment.setDataS3Id(id);
    }

    private static String getProviderFolder(Attachment attachment) {
        String folder = PROVIDER_2_FOLDER.get(attachment.getProvider());
        if (folder != null) {
            return folder;
        } else {
            throw new IllegalStateException(
                    "A separate s3 folder should be specified for attachment provider type " + attachment);
        }
    }
}
