package ru.yandex.travel.orders.services.avia.aeroflot;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.javamoney.moneta.Money;

import ru.yandex.avia.booking.enums.PassengerCategory;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AeroflotMqData {
    private static final ZoneId MSC_TIMEZONE_ID = ZoneId.of("Europe/Moscow");
    private static final DateTimeFormatter PNR_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private ZonedDateTime sentDate;
    private ZonedDateTime bookingDate;
    private String pnr;
    private String email;
    private String phone;
    private List<String> tickets;
    private List<PassengerRef> passengers;
    private Money totalPrice;

    private String sourceMessage;

    @Data
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class PassengerRef {

        private String firstName;
        private String lastName;
        private PassengerCategory category;
    }

    public boolean isPaid() {
        return tickets != null;
    }

    public ZonedDateTime getBookingDateMsc() {
        return bookingDate.withZoneSameInstant(MSC_TIMEZONE_ID);
    }

    public ZonedDateTime getSentDateMsc() {
        return sentDate.withZoneSameInstant(MSC_TIMEZONE_ID);
    }

    public String getPnrDate() {
        return "PNR_date_" + bookingDate.toLocalDate().format(PNR_DATE_FORMATTER);
    }
}
