package ru.yandex.travel.orders.services.avia.aeroflot;

import java.time.Duration;
import java.time.ZoneId;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "aeroflot-mq", ignoreUnknownFields = false)
@Validated
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class AeroflotMqProperties {
    @NotNull
    private Boolean enabled;

    @NotEmpty
    private String sqsEndpoint;
    @NotEmpty
    private String sqsRegion;
    @NotEmpty
    private String sqsUser;
    @NotEmpty
    private String sqsPassword;
    @NotEmpty
    private String sqsQueueName;

    @NotNull
    private Duration repeatInterval;
    @NotNull
    private Duration readVisibilityTimeout;
    @NotNull
    @Min(1)
    @Max(10)
    private Integer readMessagesLimit;
    @NotNull
    private Duration processingDelay;
    @NotNull
    private ZoneId apiTimeZoneId;
    @NotNull
    private ZoneId mqTimeZoneId;
}
