package ru.yandex.travel.orders.services.avia.aeroflot;

import java.util.UUID;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import ru.yandex.travel.orders.entities.AeroflotMqMessage;
import ru.yandex.travel.orders.entities.WellKnownWorkflow;
import ru.yandex.travel.orders.repository.AeroflotMqMessageRepository;
import ru.yandex.travel.orders.workflow.orderitem.aeroflot.mq.proto.EAeroflotMqMessageState;
import ru.yandex.travel.orders.workflow.orderitem.aeroflot.mq.proto.TAeroflotMqMessageProcessingStarted;
import ru.yandex.travel.workflow.WorkflowMessageSender;
import ru.yandex.travel.workflow.entities.Workflow;
import ru.yandex.travel.workflow.repository.WorkflowRepository;

@Service
@RequiredArgsConstructor
@Slf4j
public class AeroflotMqService {
    private final AeroflotMqMessageRepository mqMessageRepository;
    private final WorkflowRepository workflowRepository;
    private final WorkflowMessageSender workflowMessageSender;

    @Transactional
    public void scheduleMessageProcessing(AeroflotMqRawData rawData) {
        AeroflotMqMessage message = new AeroflotMqMessage();
        message.setState(EAeroflotMqMessageState.MS_NEW);
        message.setId(UUID.randomUUID());
        message.setData(rawData.getData());
        message = mqMessageRepository.saveAndFlush(message);
        Workflow workflowForTicket = Workflow.createWorkflowForEntity(message, WellKnownWorkflow.GENERIC_ERROR_SUPERVISOR.getUuid());
        workflowForTicket = workflowRepository.saveAndFlush(workflowForTicket);
        workflowMessageSender.scheduleEvent(workflowForTicket.getId(),
                TAeroflotMqMessageProcessingStarted.newBuilder().build());
        log.info("A new workflow ha been started to process the aeroflot mq message: " +
                "messageId={}, workflowId={}", rawData.getId(), workflowForTicket.getId());
    }
}
