package ru.yandex.travel.orders.services.avia.aeroflot;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import org.springframework.stereotype.Service;

import ru.yandex.avia.booking.partners.gateways.aeroflot.model.AeroflotTicketCouponStatusCode;
import ru.yandex.travel.orders.workflow.orderitem.aeroflot.proto.EAeroflotCouponState;

import static ru.yandex.travel.commons.map.MappingUtils.getMappingOrThrow;

@Service
public class AeroflotOrderCouponStateMapper {

    private static final BiMap<AeroflotTicketCouponStatusCode, EAeroflotCouponState> ORDER_COUPON_STATE_PROTO_TO_API =
            ImmutableBiMap.<AeroflotTicketCouponStatusCode, EAeroflotCouponState>builder()
            .put(AeroflotTicketCouponStatusCode.OK, EAeroflotCouponState.CS_OK)
            .put(AeroflotTicketCouponStatusCode.VOIDED, EAeroflotCouponState.CS_VOIDED)
            .put(AeroflotTicketCouponStatusCode.FLOWN, EAeroflotCouponState.CS_FLOWN)
            .put(AeroflotTicketCouponStatusCode.CHECKED_IN, EAeroflotCouponState.CS_CHECKED_IN)
            .put(AeroflotTicketCouponStatusCode.REFUNDED, EAeroflotCouponState.CS_REFUNDED)
            .put(AeroflotTicketCouponStatusCode.EXCHANGED, EAeroflotCouponState.CS_EXCHANGED)
            .put(AeroflotTicketCouponStatusCode.AIRPORT_CONTROL, EAeroflotCouponState.CS_AIRPORT_CONTROL)
            .build();

    public static AeroflotTicketCouponStatusCode getCouponStatusCode(EAeroflotCouponState state) {
        return getMappingOrThrow(ORDER_COUPON_STATE_PROTO_TO_API.inverse(), state);
    }

    public static EAeroflotCouponState getCouponStatusCode(AeroflotTicketCouponStatusCode state) {
        return ORDER_COUPON_STATE_PROTO_TO_API.getOrDefault(state, EAeroflotCouponState.CS_UNKNOWN);
    }
}
