package ru.yandex.travel.orders.services.avia.aeroflot;

import java.time.Duration;

import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.task_processor.TaskProcessorProperties;

@Validated
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ConfigurationProperties(value = "aeroflot-state-sync", ignoreUnknownFields = false)
public class AeroflotOrderStateSyncProperties {
    @NotNull
    private boolean enabled;
    @NotNull
    private TaskProcessorProperties ordersListRefresherTask;
    @NotNull
    private TaskProcessorProperties orderUpdaterTask;
    @NotNull
    private int requestLimitCount;
    @NotNull
    private Duration requestLimitPeriod;  //  rate = requestsLimitCount/requestsLimitPeriod  == [count/period]
    @NotNull
    private Duration defaultDelay;
    @NotNull
    private Duration responseExpiration;
}
