package ru.yandex.travel.orders.services.buses;

import java.math.BigDecimal;
import java.util.List;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.bus.model.BusPartner;

@ConfigurationProperties(value = "bus-partners", ignoreUnknownFields = false)
@Validated
@Getter
@Setter
public class BusPartnersProperties {
    @Setter
    @Getter
    @Validated
    public static class PartnerProperties {
        @Positive
        private int id;
        @NotNull
        private BusPartner partner;
        @NotNull
        private BigDecimal yandexFeePercent;
    }

    @NotNull
    private BusPartnersProperties.PartnerProperties atlasbus;

    @NotNull
    private BusPartnersProperties.PartnerProperties busfor;

    @NotNull
    private BusPartnersProperties.PartnerProperties ecolines;

    @NotNull
    private BusPartnersProperties.PartnerProperties etraffic;

    @NotNull
    private BusPartnersProperties.PartnerProperties noy;

    @NotNull
    private BusPartnersProperties.PartnerProperties ok;

    @NotNull
    private BusPartnersProperties.PartnerProperties ruset;

    @NotNull
    private BusPartnersProperties.PartnerProperties sks;

    @NotNull
    private BusPartnersProperties.PartnerProperties unitikiNew;

    @NotNull
    private BusPartnersProperties.PartnerProperties yugavtotrans;

    public List<PartnerProperties> getAllPartners() {
        return List.of(busfor, ecolines, etraffic, noy, ok, ruset, sks, unitikiNew, yugavtotrans);
    }
}
