package ru.yandex.travel.orders.services.cloud.s3;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@ConfigurationProperties(value = "cloud.s3", ignoreUnknownFields = false)
@Validated
public class S3ServiceProperties {
    // Connection properties
    @NotEmpty
    private String endpoint;
    private String accessKey;
    private String accessSecret;
    @NotNull
    private Boolean useTvm;
    private String tvmAlias;

    // App-specific properties
    @NotEmpty
    private String bucket;
    @Positive
    private Integer maxInMemoryFileSize;
}
