package ru.yandex.travel.orders.services.cpa;

import java.util.List;

import io.grpc.stub.StreamObserver;

import ru.yandex.travel.orders.cpa.ECpaOrderStatus;
import ru.yandex.travel.orders.cpa.TBoyOrdersReq;
import ru.yandex.travel.orders.cpa.TListSnapshotsReqV2;
import ru.yandex.travel.orders.cpa.TOrderSnapshot;
import ru.yandex.travel.orders.entities.Order;

public interface CpaSnapshotProvider {
    boolean supports(Order order);

    boolean supports(TListSnapshotsReqV2 request);

    List<TOrderSnapshot> getSnapshotsV2(TListSnapshotsReqV2 request);

    /**
     * Used in {@link ru.yandex.travel.orders.grpc.CpaOrderSnapshotService#getBoyOrders(TBoyOrdersReq, StreamObserver)}.
     * Applicability of the provider is checked with {@link #supports(Order)}
     */
    ECpaOrderStatus getCpaOrderStatus(Order order);
}
