package ru.yandex.travel.orders.services.email;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import ru.yandex.travel.commons.logging.NestedMdc;
import ru.yandex.travel.orders.services.MailSenderService;
import ru.yandex.travel.orders.services.OperationTypes;
import ru.yandex.travel.workflow.single_operation.SimpleSingleOperationRunner;

@Component
@RequiredArgsConstructor
@Slf4j
public class AsyncEmailOperation extends SimpleSingleOperationRunner.Void<SendEmailParams> {
    public static final OperationTypes TYPE = OperationTypes.ASYNC_EMAIL_SENDER;

    private final MailSenderService sender;

    @Override
    protected void runVoidOperation(SendEmailParams params) {
        try (NestedMdc ignored = NestedMdc.forOptionalEntityId(params.getContextEntityId())) {
            try {
                log.info("Sending email {} to {}", params.getCampaignId(), params.getTargets());
                sender.sendEmailSync(params.getCampaignId(), null,
                        params.getTargets(), params.getCopies(), params.getBlindCopies(),
                        params.getArguments(), params.getAttachments());
                log.info("Sending email complete (asynchronously)");
            } catch (Exception e) {
                log.info("Sending email failed", e);
                throw e;
            }
        }
    }
}
