package ru.yandex.travel.orders.services.email;

import java.util.List;
import java.util.UUID;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Builder;
import lombok.Data;
import lombok.extern.jackson.Jacksonized;

import ru.yandex.travel.orders.entities.notifications.MailSenderAttachment;
import ru.yandex.travel.orders.entities.notifications.MailTarget;
import ru.yandex.travel.orders.services.MailSenderServiceImpl;

@Data
@Builder
@Jacksonized
public class SendEmailParams {
    private String campaignId;
    private List<MailTarget> targets;
    private List<MailTarget> copies;
    private List<MailTarget> blindCopies;
    // in case of async operations this parameter should have a fixed field names case
    private JsonNode arguments;
    private List<MailSenderAttachment> attachments;
    // used for AsyncEmailOperation-s
    private UUID contextEntityId;

    public static JsonNode wrapArgs(Object args) {
        return MailSenderServiceImpl.convertArguments(args);
    }
}
