package ru.yandex.travel.orders.services.finances;

import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ConfigurationProperties(value = "financial-events", ignoreUnknownFields = false)
@Validated
public class FinancialEventServiceProperties {
    @NotNull
    public Boolean enabled;

    @NotNull
    public Boolean enablePromoFee;
}
