package ru.yandex.travel.orders.services.finances;

import java.time.Instant;

import com.google.common.base.Preconditions;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import ru.yandex.travel.hotels.administrator.export.proto.HotelAgreement;
import ru.yandex.travel.hotels.proto.EPartnerId;
import ru.yandex.travel.orders.cache.HotelAgreementDictionary;

@Service
@RequiredArgsConstructor
@Slf4j
public class HotelAgreementService {

    private final HotelAgreementDictionary hotelAgreementDictionary;

    public HotelAgreement getAgreementForTimestamp(String hotelId, EPartnerId partnerId, Instant instant) {
        HotelAgreement hotelAgreement = hotelAgreementDictionary.findAgreementByHotelIdAndTimestamp(partnerId,
                hotelId, instant);
        Preconditions.checkNotNull(hotelAgreement,
                "Agreement not found for hotel %s of partner %s and timestamp %s", hotelId, partnerId.toString(),
                instant);
        return hotelAgreement;
    }
}
