package ru.yandex.travel.orders.services.finances;

import java.time.Duration;
import java.util.List;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.task_processor.TaskProcessorProperties;


@Component
@Data
@NoArgsConstructor
@ConfigurationProperties(value = "hotel-agreements", ignoreUnknownFields = false)
@Validated
public class HotelAgreementServiceProperties {
    @NotNull
    private TaskProcessorProperties taskProcessor;

    @NotNull
    @Valid
    private YtCacheProperties ytCache;

    @Data
    public static class YtCacheProperties {
        @NotEmpty
        private List<String> proxy;
        @NotEmpty
        private String token;
        @NotEmpty
        private String hotelAgreementsYtTable;
        @NotEmpty
        private String baseLocalPath;
        private Duration updateInterval;
    }
}
