package ru.yandex.travel.orders.services.finances;

import javax.money.CurrencyUnit;

import lombok.Builder;
import lombok.NonNull;
import lombok.Value;
import org.javamoney.moneta.Money;

@Value
@Builder
public class OverallServiceBalance {
    @NonNull
    private final Money userPartner;
    @NonNull
    private final Money userFee;
    @NonNull
    private final Money plusPartner;
    @NonNull
    private final Money plusFee;
    @NonNull
    private final Money promoPartner;
    @NonNull
    private final Money promoFee;
    @NonNull
    private final Money techFee;

    public Money getPromo() {
        return promoPartner.add(promoFee);
    }

    public Money getPartner() {
        return userPartner.add(plusPartner).add(promoPartner);
    }

    public Money getFee() {
        return userFee.add(plusFee).add(promoFee);
    }

    public Money getTotal() {
        return getPartner().add(getFee());
    }

    public CurrencyUnit getCurrency() {
        return getTotal().getCurrency();
    }
}
