package ru.yandex.travel.orders.services.finances.billing;

import java.time.Duration;
import java.time.LocalDate;

import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.task_processor.TaskProcessorProperties;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder(toBuilder = true)
@Validated
public class BillingBankOrderSyncProperties {
    private boolean enabled;
    private Duration refreshInterval;
    private Duration startDelay;
    @NotNull
    private Duration emailsSendingDelay;

    @NotNull
    private TaskProcessorProperties bankPaymentProcessor;
    @NotNull
    private TaskProcessorProperties billingFetchingBankOrdersProcessor;

    private int bankPaymentCheckAttempts;
    private Duration bankPaymentAttemptDelay;

    @DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
    private LocalDate startDate;
    private int maxIntervalDays;
}
