package ru.yandex.travel.orders.services.finances.billing;

import java.util.Collection;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.task_processor.AbstractSimpleTask;

@Slf4j
@RequiredArgsConstructor
public class BillingFetchingBankOrderSyncTask extends AbstractSimpleTask<BillingBankOrderSyncService.DateInterval> {

    private final BillingBankOrderSyncService billingBankOrderSyncService;

    @Override
    public void process(BillingBankOrderSyncService.DateInterval key) {
        billingBankOrderSyncService.fetchBatchBankOrders(key);
    }

    @Override
    public Collection<BillingBankOrderSyncService.DateInterval> getPendingTaskKeys(int maxResultSize) {
        return billingBankOrderSyncService
                .getIntervalsForFetching()
                .stream()
                .limit(maxResultSize)
                .collect(Collectors.toUnmodifiableSet());

    }

    @Override
    public long getPendingTasksCount() {
        return billingBankOrderSyncService.countIntervalsForFetching();
    }
}
