package ru.yandex.travel.orders.services.finances.billing;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

import ru.yandex.travel.orders.entities.HotelOrderItem;

public class BillingHelper {
    public static final ZoneId BILLING_TIME_ZONE = ZoneId.of("Europe/Moscow");
    public static final DateTimeFormatter BILLING_DATE_TIME_FORMAT =
            DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");

    public static LocalDateTime toBillingDate(Instant instant) {
        return instant.atZone(BILLING_TIME_ZONE).toLocalDateTime();
    }

    public static Instant getBillingDayStart(Instant instant) {
        return getBillingDayStart(toBillingDate(instant).toLocalDate());
    }

    public static Instant getBillingDayStart(LocalDate date) {
        return date.atStartOfDay()
                .atZone(BILLING_TIME_ZONE)
                .toInstant();
    }

    public static Instant getBillingDayEnd(LocalDate date) {
        return date.atTime(LocalTime.MAX)
                .atZone(BILLING_TIME_ZONE)
                .toInstant();
    }

    public static Instant getLastBillingDayOfMonth(Instant instant) {
        return getLastBillingDayOfMonth(toBillingDate(instant).toLocalDate());
    }

    public static Instant getLastBillingDayOfMonth(LocalDate date) {
        return getBillingDayStart(date.withDayOfMonth(date.lengthOfMonth()));
    }

    public static Instant getLastBillingDayOfCheckoutMonth(HotelOrderItem hotelOrderItem) {
        LocalDate checkOut = hotelOrderItem.getHotelItinerary().getOrderDetails().getCheckoutDate();
        return getLastBillingDayOfMonth(checkOut);
    }

    public static Instant getNextBillingMondayAfterCheckout(HotelOrderItem hotelOrderItem) {
        LocalDate checkOut = hotelOrderItem.getHotelItinerary().getOrderDetails().getCheckoutDate();

        int currentDayOfWeek = checkOut.getDayOfWeek().getValue() - 1;

        return getBillingDayStart(checkOut.plusDays(7 - currentDayOfWeek));
    }
}
