package ru.yandex.travel.orders.services.finances.billing;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.validation.annotation.Validated;

@Data
@Builder(toBuilder = true)
@NoArgsConstructor
@AllArgsConstructor
@Validated
public class BillingTransactionYtTableClientProperties {
    @NotEmpty
    private String cluster;
    @NotEmpty
    private String token;
    @NotEmpty
    private String tablesDirectory;
    @NotEmpty
    private String incomeTablesDirectory;
    @NotNull
    private Duration transactionDuration;
    @NotNull
    private Integer batchSize;
}
