package ru.yandex.travel.orders.services.finances.billing;

import java.time.Duration;
import java.time.Instant;

import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.orders.entities.finances.ProcessingTasksInfo;

@Slf4j
class ProcessingDelaysHelper {
    public static Duration getDelay(ProcessingTasksInfo tasksInfo, String taskProcessorName, Instant delaySince) {
        if (tasksInfo.getOldestProcessAt() == null) {
            boolean isEmptyQueue = tasksInfo.getCount() == 0;
            return getDefaultDelay(isEmptyQueue, taskProcessorName);
        }
        return Duration.between(tasksInfo.getOldestProcessAt(), delaySince);
    }

    public static Duration getDefaultDelay(boolean isEmptyQueue, String taskProcessorName) {
        if (isEmptyQueue) {
            return Duration.ZERO;
        } else {
            log.warn("Processing delay hasn't been found for the {} task processor",
                    taskProcessorName, new IllegalStateException("Shouldn't happen in prod or testing"));
            // the value should be high enough to trigger alerts (but not too huge enough to break graphs)
            return Duration.ofHours(24);
        }
    }
}
