package ru.yandex.travel.orders.services.finances.providers;

import java.math.BigDecimal;
import java.util.Map;

import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.validation.annotation.Validated;

@Validated
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class DolphinFinancialDataProviderProperties {
    @NotNull
    private Long billingClientId;
    @NotNull
    private Long billingContractId;
    @NotNull
    @Min(0)
    @Max(1)
    private BigDecimal agentFeePercent;
    @NotEmpty
    private Map<Integer, BigDecimal> refundPenalties;
}
