package ru.yandex.travel.orders.services.finances.providers;

import lombok.RequiredArgsConstructor;
import org.javamoney.moneta.Money;
import org.springframework.stereotype.Service;

import ru.yandex.travel.orders.entities.HotelOrderItem;
import ru.yandex.travel.orders.entities.OrderItem;
import ru.yandex.travel.orders.entities.VatType;
import ru.yandex.travel.orders.services.finances.OverallServiceBalance;
import ru.yandex.travel.orders.workflows.orderitem.expedia.ExpediaProperties;

// Real payouts are made by hand in USD: https://st.yandex-team.ru/YATRAVELBD-170
// Here we try to approximate the data based on average fee rate
@Service
@RequiredArgsConstructor
public class ExpediaVirtualFinancialDataProvider {
    private final ExpediaProperties properties;

    public OverallServiceBalance getApproximateOverallServiceBalance(OrderItem orderItem) {
        HotelOrderItem hotelOrderItem = (HotelOrderItem) orderItem;
        Money total = hotelOrderItem.getHotelItinerary().getFiscalPrice();
        MoneySplit split = ProviderHelper.splitMoney(total, properties.getApproximateFeeRate());
        return OverallServiceBalance.builder()
                .userPartner(split.getPartner())
                .userFee(split.getFee())
                .plusPartner(Money.zero(total.getCurrency()))
                .plusFee(Money.zero(total.getCurrency()))
                .promoPartner(Money.zero(total.getCurrency()))
                .promoFee(Money.zero(total.getCurrency()))
                .techFee(Money.zero(total.getCurrency()))
                .build();
    }

    public VatType getYandexFeeVat(OrderItem orderItem) {
        return properties.getVatType();
    }
}
