package ru.yandex.travel.orders.services.finances.providers;

import java.time.Instant;
import java.util.List;

import org.javamoney.moneta.Money;

import ru.yandex.travel.orders.commons.proto.EServiceType;
import ru.yandex.travel.orders.entities.OrderItem;
import ru.yandex.travel.orders.entities.OrderRefund;
import ru.yandex.travel.orders.entities.Payment;
import ru.yandex.travel.orders.entities.PaymentSchedule;
import ru.yandex.travel.orders.entities.VatType;
import ru.yandex.travel.orders.entities.finances.FinancialEvent;
import ru.yandex.travel.orders.services.finances.proto.EMoneyRefundMode;

/**
 * Generates {@link FinancialEvent}s for different order events.
 */
public interface FinancialDataProvider {
    List<EServiceType> getServiceTypes();

    List<FinancialEvent> onConfirmation(OrderItem orderItem, Boolean enablePromoFee);

    List<FinancialEvent> onExtraPayment(OrderItem orderItem, Payment extraPayment, Boolean enablePromoFee);

    List<FinancialEvent> onRefund(OrderItem orderItem, EMoneyRefundMode moneyRefundMode, Boolean enablePromoFee);

    List<FinancialEvent> onRefund(OrderItem orderItem, EMoneyRefundMode moneyRefundMode, Boolean enablePromoFee,
                                  Money penalty, Money refund, Instant refundedAt);

    List<FinancialEvent> onPartialRefund(OrderItem orderItem, OrderRefund partialRefund, Boolean enablePromoFee);

    List<FinancialEvent> onPaymentScheduleFullyPaid(OrderItem orderItem, PaymentSchedule schedule, Boolean enablePromoFee);

    default List<FinancialEvent> onUpdateFinancialEventsWithoutBalanceChanges(OrderItem orderItem,
                                                                              Boolean enablePromoFee,
                                                                              Boolean inferBillingIdsFromEvents) {
        throw new UnsupportedOperationException("UpdateFinancialEventsWithoutBalanceChanges supported only for hotels direct boy");
    }

    VatType getYandexFeeVat(OrderItem orderItem);
}
