package ru.yandex.travel.orders.services.finances.tasks;

import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.services.finances.HotelAgreementServiceProperties;
import ru.yandex.travel.orders.services.finances.billing.BillingPartnerConfigSynchronizer;
import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.TaskProcessor;
import ru.yandex.travel.task_processor.TaskProcessorHelper;

@Configuration
@RequiredArgsConstructor
public class BillingPartnerSyncConfiguration {

    private final BillingPartnerConfigSynchronizer billingPartnerConfigSynchronizer;
    private final ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper;
    private final HotelAgreementServiceProperties hotelAgreementServiceProperties;

    @Bean
    public TaskProcessor<String> billingPartnerConfigSynchronizerTaskProcessor() {
        return new TaskProcessor<>(
                billingPartnerConfigSynchronizer,
                billingPartnerConfigSynchronizer::insertMissingClientIdsIntoBillingPartnerConfig,
                forcedRollbackTxManagerWrapper,
                TaskProcessorHelper.createDefaultTxDefinition("billingPartnerConfigSyncTaskTxDefinition"),
                hotelAgreementServiceProperties.getTaskProcessor()
        );
    }
}
