package ru.yandex.travel.orders.services.hotels;

import ru.yandex.travel.hotels.common.orders.GeoRegion;
import ru.yandex.travel.hotels.common.orders.OrderDetails;

public class HotelOrderDetailsHelpers {
    public static final int COUNTRY_REGION_TYPE = 3;
    public static final int CITY_REGION_TYPE = 6;

    public static GeoRegion getHotelCountry(OrderDetails orderDetails) {
        return getHotelRegionOfType(orderDetails, COUNTRY_REGION_TYPE);
    }

    public static GeoRegion getHotelCity(OrderDetails orderDetails) {
        return getHotelRegionOfType(orderDetails, CITY_REGION_TYPE);
    }

    private static GeoRegion getHotelRegionOfType(OrderDetails orderDetails, int regionType) {
        if (orderDetails.getHotelGeoRegions() == null) {
            return null;
        }
        for (var region : orderDetails.getHotelGeoRegions()) {
            if (region.getType() == regionType) {
                return region;
            }
        }
        return null;
    }
}
