package ru.yandex.travel.orders.services.hotels;

import java.util.EnumMap;

import com.google.common.collect.ImmutableMap;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import org.springframework.stereotype.Component;

import ru.yandex.travel.hotels.common.orders.CancellationDetails;
import ru.yandex.travel.hotels.proto.EPartnerId;

@Component
public class Meters {

    private final ImmutableMap<EPartnerId, ImmutableMap<CancellationDetails.Reason, Counter>> cancellationCounters;
    private final ImmutableMap<EPartnerId, Counter> confirmationCounters;

    public Meters() {
        //Initialize counters for all possible Partners and CancellationReasons
        EnumMap<EPartnerId, ImmutableMap<CancellationDetails.Reason, Counter>> cancellationCountersBuilder =
                new EnumMap<>(EPartnerId.class);
        EnumMap<EPartnerId, Counter> confirmationCounterMapBuilder = new EnumMap<EPartnerId, Counter>(EPartnerId.class);
        for (EPartnerId partnerId : EPartnerId.values()) {
            EnumMap<CancellationDetails.Reason, Counter> reasonMapBuilder =
                    new EnumMap<>(CancellationDetails.Reason.class);
            for (CancellationDetails.Reason reason : CancellationDetails.Reason.values()) {
                reasonMapBuilder.put(reason, Counter.builder("orders.hotels.cancelled")
                        .tag("partner", partnerId.toString())
                        .tag("reason", reason.toString())
                        .register(Metrics.globalRegistry));
            }
            confirmationCounterMapBuilder.put(partnerId, Counter.builder("orders.hotels.confirmed")
                            .tag("partner", partnerId.toString())
                            .register(Metrics.globalRegistry));
            cancellationCountersBuilder.put(partnerId, ImmutableMap.copyOf(reasonMapBuilder));
        }
        cancellationCounters = ImmutableMap.copyOf(cancellationCountersBuilder);
        confirmationCounters = ImmutableMap.copyOf(confirmationCounterMapBuilder);
    }

    public void incrementCancellationCounter(EPartnerId partnerId, CancellationDetails.Reason cancellationReason) {
        cancellationCounters.get(partnerId).get(cancellationReason).increment();
    }

    public void incrementCancellationCounter(EPartnerId partnerId, String cancellationReason) {
        cancellationCounters.get(partnerId).get(CancellationDetails.Reason.valueOf(cancellationReason)).increment();
    }

    public void incrementConfirmationCounter(EPartnerId partnerId) {
        confirmationCounters.get(partnerId).increment();
    }

}
