package ru.yandex.travel.orders.services.hotels_extranet;

import lombok.experimental.UtilityClass;

import ru.yandex.travel.hotels.extranet.EBankOrderTransactionPaymentType;
import ru.yandex.travel.hotels.extranet.EBankOrderTransactionTransactionType;
import ru.yandex.travel.hotels.extranet.TGetDBoyReq;
import ru.yandex.travel.orders.entities.finances.BillingTransactionPaymentType;
import ru.yandex.travel.orders.entities.finances.BillingTransactionType;

@UtilityClass
class HotelsExtranetMappingUtils {
    public static EBankOrderTransactionTransactionType getTransactionType(BillingTransactionType type) {
        switch (type) {
            case REFUND:
                return EBankOrderTransactionTransactionType.BTTT_REFUND;
            case PAYMENT:
                return EBankOrderTransactionTransactionType.BTTT_PAYMENT;
            default:
                return EBankOrderTransactionTransactionType.BTTT_UNKNOWN;
        }
    }

    public static EBankOrderTransactionPaymentType getPaymentType(BillingTransactionPaymentType type) {
        try {
            return EBankOrderTransactionPaymentType.valueOf("BTPT_" + type.name());
        } catch (IllegalArgumentException e) {
            return EBankOrderTransactionPaymentType.BTPT_UNKNOWN;
        }
    }

    public static int getLimit(TGetDBoyReq req) {
        if (req.getLimit() <= 0) {
            return 100;
        }
        return req.getLimit();
    }
}
