package ru.yandex.travel.orders.services.indexing;

import java.time.Duration;
import java.util.Set;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import ru.yandex.travel.orders.commons.proto.EDisplayOrderType;

@Getter
@Setter
@ConfigurationProperties("orders-indexing")
public class OrdersIndexingConfigurationProperties {
    private boolean enabled;
    private Duration initialDelay;
    private Duration rate;
    private int numberOfOrdersToIndex;
    private Set<EDisplayOrderType> disabledOrderTypes;
}
