package ru.yandex.travel.orders.services.indexing;

import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

import ru.yandex.travel.orders.services.notifier.NotifierUpdateEventListener;
import ru.yandex.travel.orders.services.orders.OrderUpdateStateChangeEventListener;
import ru.yandex.travel.orders.services.orders.updates.OrdersUpdatesQueueStageChangeEventListener;

public class OrdersUpdateListenersIntegrator implements Integrator {
    @Override
    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory,
                          SessionFactoryServiceRegistry serviceRegistry) {
        final EventListenerRegistry eventListenerRegistry = serviceRegistry.getService(EventListenerRegistry.class);

        eventListenerRegistry.appendListeners(EventType.POST_UPDATE, new IndexingUpdateEventListener());
        eventListenerRegistry.appendListeners(EventType.POST_UPDATE, new OrderUpdateStateChangeEventListener());
        eventListenerRegistry.appendListeners(EventType.POST_UPDATE, new NotifierUpdateEventListener());
        eventListenerRegistry.appendListeners(EventType.POST_UPDATE, new OrdersUpdatesQueueStageChangeEventListener());
    }

    @Override
    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {

    }
}
