package ru.yandex.travel.orders.services.migrations;

import java.time.Duration;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "migration.order-details")
@Data
public class OrderDetailsMigratorConfigurationProperties {
    private boolean enabled;
    @Min(1)
    private int concurrentMigrations;
    @Min(1)
    private int prefetchItemCount;
    @NotNull
    private Duration initialStartDelay;
    @NotNull
    private Duration period;

}
