package ru.yandex.travel.orders.services.migrations;

import java.time.LocalDate;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

import ru.yandex.travel.hotels.common.LocationType;

@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class OrderInfo {
    private RequestInfo requestInfo;
    private PartnerHotelInfo partnerHotelInfo;
    private PartnerRoomInfo partnerRoomInfo;
    private BasicHotelInfo basicHotelInfo;


    @JsonIgnoreProperties(ignoreUnknown = true)
    @Data
    public static class RequestInfo {
        private LocalDate checkinDate;
        private LocalDate checkoutDate;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @Data
    public static class PartnerHotelInfo {
        private String propertyId;
        private String name;
        private Checkin checkin;
        private Checkout checkout;

        @JsonIgnoreProperties(ignoreUnknown = true)
        @Data
        public static class Checkin {
            private String beginTime;
            private String endTime;
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        @Data
        public static class Checkout {
            private String time;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @Data
    public static class PartnerRoomInfo {
        private String name;
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    @Data
    public static class BasicHotelInfo {
        private LocationType locationType;
        private Long permalink;
    }
}
