package ru.yandex.travel.orders.services.migrations.attachments;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.TaskProcessor;
import ru.yandex.travel.task_processor.TaskProcessorHelper;
import ru.yandex.travel.task_processor.TaskProcessorProperties;

@ConditionalOnProperty("migration.attachment-data-to-s3-task.enabled")
@Configuration
public class AttachmentDataToS3MigrationConfiguration {
    @ConfigurationProperties(value = "migration.attachment-data-to-s3-task", ignoreUnknownFields = false)
    @Bean
    public TaskProcessorProperties attachmentDataToS3MigrationTaskProcessorProperties() {
        return TaskProcessorProperties.builder()
                .name("AttachmentDataToS3Migration")
                .daemonPoolThreads(true)
                .gracefulPoolShutdown(true)
                .build();
    }

    @Bean
    public TaskProcessor<UUID> attachmentDataToS3MigrationTaskProcessor(
            @Qualifier("attachmentDataToS3MigrationTaskProcessorProperties") TaskProcessorProperties properties,
            AttachmentDataToS3MigrationProcessor processor,
            ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper
    ) {
        return TaskProcessorHelper.simpleTaskProcessor(processor, forcedRollbackTxManagerWrapper, properties);
    }
}
