package ru.yandex.travel.orders.services.migrations.attachments;

import java.util.Collection;
import java.util.UUID;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import ru.yandex.travel.orders.repository.migrations.AttachmentDataToS3MigrationRepository;
import ru.yandex.travel.orders.services.cloud.s3.S3Service;
import ru.yandex.travel.task_processor.AbstractSimpleTask;

import static ru.yandex.travel.orders.repository.JpaRepositoryUtils.NO_EXCLUDE_UUIDS;
import static ru.yandex.travel.orders.repository.JpaRepositoryUtils.firstPage;

@Component
@RequiredArgsConstructor
@Slf4j
public class AttachmentDataToS3MigrationProcessor extends AbstractSimpleTask<UUID> {
    private final AttachmentDataToS3MigrationRepository repository;
    private final S3Service s3Service;

    @Override
    public Collection<UUID> getPendingTaskKeys(int maxResultSize) {
        return repository.findAttachmentIdsWithData(getLockedTaskKeysSafe(NO_EXCLUDE_UUIDS), firstPage(maxResultSize));
    }

    @Override
    public long getPendingTasksCount() {
        return repository.countAttachmentIdsWithData(getLockedTaskKeysSafe(NO_EXCLUDE_UUIDS));
    }

    @Override
    public void process(UUID attachmentId) {
        throw new IllegalStateException("There shouldn't be any attachments to migrate, " +
                "keeping this Task only as a reference of a simple TaskProcessing implementation & configuration");
        /*
        try (NestedMdc ignored = NestedMdc.forEntityId(attachmentId)) {
            try {
                Attachment attachment = repository.getOne(attachmentId);
                Preconditions.checkState(attachment.getData() != null, "The data field can't be unset");
                log.info("Migrating attachment data: {} bytes", attachment.getData().length);

                byte[] data = attachment.getData();
                attachment.setData(null);
                AttachmentsHelper.storeAttachmentData(attachment, data, s3Service);
                Preconditions.checkState(attachment.getData() == null, "The data field has to be unset");
                Preconditions.checkState(attachment.getDataS3Id() != null, "An S3 id has to be present after upload");

                log.info("The data has been successfully uploaded to s3 with id '{}'", attachment.getDataS3Id());
            } catch (Exception e) {
                log.warn("An exception occurred during migration: {}", e.getMessage());
                throw e;
            }
        }
        */
    }
}
