package ru.yandex.travel.orders.services.migrations.generic;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.TaskProcessor;
import ru.yandex.travel.task_processor.TaskProcessorHelper;
import ru.yandex.travel.task_processor.TaskProcessorProperties;

@ConditionalOnProperty("migration.train-to-generic-task.enabled")
@Configuration
public class TrainToGenericMigrationConfiguration {
    @ConfigurationProperties(value = "migration.train-to-generic-task", ignoreUnknownFields = false)
    @Bean
    public TaskProcessorProperties trainToGenericMigrationTaskProcessorProperties() {
        return TaskProcessorProperties.builder()
                .name("TrainToGenericMigrator")
                .daemonPoolThreads(true)
                .gracefulPoolShutdown(true)
                .build();
    }

    @Bean
    public TaskProcessor<UUID> trainToGenericMigrationTaskProcessor(
            @Qualifier("trainToGenericMigrationTaskProcessorProperties") TaskProcessorProperties properties,
            TrainToGenericMigrationProcessor processor,
            ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper
    ) {
        return new TaskProcessor<>(
                processor,
                processor::migrate,
                forcedRollbackTxManagerWrapper,
                TaskProcessorHelper.createDefaultTxDefinition("trainToGenericMigrationTaskTxDefinition"),
                properties
        );
    }
}
