package ru.yandex.travel.orders.services.mock;

import java.util.concurrent.ThreadLocalRandom;

import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;

@Slf4j
class AbstractMockClient {
    private final long callDelayMinMillis;
    private final long callDelayMaxMillis;

    public AbstractMockClient(long callDelayMinMillis, long callDelayMaxMillis) {
        Preconditions.checkArgument(callDelayMinMillis <= callDelayMaxMillis,
                "Call delay min must be less or equal to max");
        this.callDelayMinMillis = callDelayMinMillis;
        this.callDelayMaxMillis = callDelayMaxMillis;
    }

    protected final void sleepRandomly() {
        long sleepTime = ThreadLocalRandom.current().nextLong(callDelayMinMillis, callDelayMaxMillis + 1);
        if (sleepTime == 0) {
            return;
        }
        try {
            log.info("Mock client {}: random delay of {} ms", getClass().getSimpleName(), sleepTime);
            Thread.sleep(sleepTime);
        } catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}
