package ru.yandex.travel.orders.services.mock;

import java.time.Duration;
import java.util.Collection;

import ru.yandex.travel.orders.entities.notifications.MailSenderAttachment;
import ru.yandex.travel.orders.entities.notifications.MailTarget;
import ru.yandex.travel.orders.services.MailSenderService;

public class MockMailSenderService extends AbstractMockClient implements MailSenderService {

    public MockMailSenderService(Duration callDelayMin, Duration callDelayMax) {
        super(callDelayMin.toMillis(), callDelayMax.toMillis());
    }

    @Override
    public void sendEmailSync(String campaignId, String targetEmail, Collection<MailTarget> multipleTargets,
                              Collection<MailTarget> copies, Collection<MailTarget> blindCopies,
                              Object args, Collection<MailSenderAttachment> attachments) {
        sleepRandomly();
    }
}
