package ru.yandex.travel.orders.services.mock;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;

import ru.yandex.travel.orders.services.pdfgenerator.PdfGeneratorService;
import ru.yandex.travel.orders.services.pdfgenerator.model.PdfGenerateBusesTicketsRequest;
import ru.yandex.travel.orders.services.pdfgenerator.model.PdfGenerateHotelsBusinessTripDocRequest;
import ru.yandex.travel.orders.services.pdfgenerator.model.PdfGenerateHotelsVoucherRequest;
import ru.yandex.travel.orders.services.pdfgenerator.model.PdfStateResponse;

public class MockPdfGenerator extends AbstractMockClient implements PdfGeneratorService {
    private byte[] voucherPdf;

    public MockPdfGenerator(Duration callDelayMin, Duration callDelayMax, byte[] voucherPdf) {
        super(callDelayMin.toMillis(), callDelayMax.toMillis());
        this.voucherPdf = voucherPdf;
    }

    @Override
    public byte[] downloadDocumentAsBytesSync(String documentUrl) {
        sleepRandomly();
        return Arrays.copyOf(voucherPdf, voucherPdf.length);
    }

    @Override
    public void generateBusesTickets(PdfGenerateBusesTicketsRequest request) {
    }

    @Override
    public void generateHotelsVoucher(PdfGenerateHotelsVoucherRequest request) {
    }

    @Override
    public void generateHotelsBusinessTripDoc(PdfGenerateHotelsBusinessTripDocRequest request) {
    }

    @Override
    public PdfStateResponse getState(String fileName) {
        var rsp = new PdfStateResponse();
        rsp.setUrl("http://some_voucher_url");
        rsp.setLastModified(Instant.now());
        return rsp;
    }

}
