package ru.yandex.travel.orders.services.mock.jobs;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.UUID;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import ru.yandex.travel.orders.services.mock.MockAeroflotMqService;
import ru.yandex.travel.orders.workflows.orderitem.aeroflot.provider.MockAeroflotProperties;
import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.AbstractTaskKeyProvider;
import ru.yandex.travel.task_processor.TaskKeyProvider;
import ru.yandex.travel.task_processor.TaskProcessor;
import ru.yandex.travel.task_processor.TaskProcessorProperties;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties(MockAeroflotProperties.class)
public class MockAeroflotMqReaderTaskProcessorConfiguration {
    private final MockAeroflotMqService mockAeroflotMqService;
    private final ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper;

    @Bean
    @ConditionalOnProperty(value = "mock-aeroflot.enabled")
    public TaskProcessor<UUID> mockAeroflotMqReaderTaskProcessor() {

        TaskKeyProvider<UUID> taskKeyProvider = new AbstractTaskKeyProvider<>() {
            @Override
            public Collection<UUID> getPendingTaskKeys(int maxResultSize) {
                return mockAeroflotMqService.fetchOrdersWaitingForEvent(getLockedTaskKeys(),
                        maxResultSize);
            }

            @Override
            public long getPendingTasksCount() {
                return mockAeroflotMqService.countOrdersWaitingForEvent(getLockedTaskKeys());
            }
        };
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setName("MockAeroflotMqReaderProcessor");
        transactionDefinition.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        transactionDefinition.setIsolationLevel(TransactionDefinition.ISOLATION_REPEATABLE_READ);
        TransactionDefinition txDefinition = new DefaultTransactionDefinition(transactionDefinition);

        return new TaskProcessor<>(taskKeyProvider, mockAeroflotMqService::scheduleMqEvent,
                forcedRollbackTxManagerWrapper, txDefinition,
                TaskProcessorProperties.builder().name("MockAeroflotMqReaderProcessor")
                        .daemonPoolThreads(true).gracefulPoolShutdown(true)
                        .poolSize(2)
                        .initialStartDelay(Duration.of(10, ChronoUnit.SECONDS))
                        .scheduleRate(Duration.of(2, ChronoUnit.SECONDS))
                        .build());
    }
}
