package ru.yandex.travel.orders.services.notifications;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

import com.google.common.collect.ImmutableMap;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import lombok.Getter;
import org.springframework.stereotype.Component;

import ru.yandex.travel.orders.entities.notifications.NotificationChannelType;
import ru.yandex.travel.orders.entities.notifications.NotificationFailureReason;

@Component
public class NotificationMeters {
    @Getter
    private final Map<NotificationChannelType, Counter> notificationsSent;

    @Getter
    private final Map<NotificationChannelType, Map<NotificationFailureReason, Counter>> notificationsFailed;

    public NotificationMeters() {
        this(Metrics.globalRegistry);
    }

    public NotificationMeters(MeterRegistry registry) {
        Map<NotificationChannelType, Counter> sentCounters = new HashMap<>();
        Map<NotificationChannelType, Map<NotificationFailureReason, Counter>> failedCounters = new HashMap<>();
        for (NotificationChannelType channel : NotificationChannelType.values()) {
            sentCounters.put(channel, Counter.builder("orders.notifications.sent")
                    .tag("channel", channel.getValue())
                    .register(registry));
            failedCounters.put(channel, ImmutableMap.copyOf(Arrays.stream(
                    NotificationFailureReason.values()).collect(Collectors.toMap(r -> r, r ->
                    Counter.builder("orders.notifications.failed")
                            .tag("channel", channel.getValue())
                            .tag("reason", r.name())
                            .register(registry)))));
        }
        notificationsSent = ImmutableMap.copyOf(sentCounters);
        notificationsFailed = ImmutableMap.copyOf(failedCounters);
    }
}
