package ru.yandex.travel.orders.services.notifications;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import com.fasterxml.jackson.databind.JsonNode;
import org.asynchttpclient.Response;

import ru.yandex.travel.orders.entities.notifications.MailSenderAttachment;

public interface TemplatedMailSenderService {
    void sendEmailSync(String targetEmail, String template, JsonNode data, List<MailSenderAttachment> attachments);

    CompletableFuture<Response> sendEmailAsync(String targetEmail,
                                               String template,
                                               JsonNode data,
                                               List<MailSenderAttachment> attachments);
}
