package ru.yandex.travel.orders.services.notifier;

import java.util.UUID;

import com.google.common.base.Preconditions;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import ru.yandex.travel.notifier.order.v1.OrderChangedReq;

@Component
@RequiredArgsConstructor
@Slf4j
public class NotifierClientImpl implements NotifierClient {
    private final NotifierClientFactory notifierClientFactory;

    @Override
    public void orderChanged(UUID orderId) {
        Preconditions.checkNotNull(orderId);
        OrderChangedReq orderChangedReq = OrderChangedReq.newBuilder().setOrderId(orderId.toString()).build();
        var orderChangedRsp = notifierClientFactory.createRoundRobinStub().orderChanged(orderChangedReq);
        log.debug("Notifier response: {}", orderChangedRsp);
    }
}

