package ru.yandex.travel.orders.services.notifier;

import java.time.Duration;

import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.task_processor.TaskProcessorProperties;

@ConfigurationProperties(prefix = "notifier-state-refresh", ignoreUnknownFields = false)
@Validated
@Getter
@Setter
public class NotifierStateRefreshConfigurationProperties {
    @NotNull
    private TaskProcessorProperties taskProcessor;

    @NotNull
    private Duration debounce; // Delay in seconds to wait after changes to orders occured

    private boolean mock;
}
