package ru.yandex.travel.orders.services.orders;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.orders.repository.OrderAggregateStateChangeRepository;
import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;
import ru.yandex.travel.task_processor.AbstractTaskKeyProvider;
import ru.yandex.travel.task_processor.TaskKeyProvider;
import ru.yandex.travel.task_processor.TaskProcessor;
import ru.yandex.travel.task_processor.TaskProcessorHelper;

@Configuration
@EnableConfigurationProperties(OrderAggregateStateRefreshConfigurationProperties.class)
@RequiredArgsConstructor
public class OrderAggregateStateRefreshConfiguration {

    private final OrderAggregateStateChangeRepository orderAggregateStateChangeRepository;

    private final OrderAggregateStateRefresher orderAggregateStateRefresher;

    private final ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper;

    private final OrderAggregateStateRefreshConfigurationProperties orderAggregateStateRefreshConfigurationProperties;

    @Bean
    public TaskProcessor<UUID> orderAggregateStateRefreshTaskProcessor() {
        TaskKeyProvider<UUID> taskKeyProvider = new AbstractTaskKeyProvider<>() {
            @Override
            public Collection<UUID> getPendingTaskKeys(int maxResultSize) {
                Set<UUID> excludeIds = getLockedTaskKeys();
                excludeIds = excludeIds == null || excludeIds.isEmpty() ?
                        OrderAggregateStateChangeRepository.NO_EXCLUDE_IDS : excludeIds;
//                List<Object[]> orderIdsAndMinDate =
//                        orderAggregateStateChangeRepository.getOrdersWaitingAggregateStateRefresh(
//                                excludeIds, maxResultSize
//                        );
//                return orderIdsAndMinDate.stream().map(arr -> UUID.fromString((String) arr[0]))
//                        .collect(Collectors.toUnmodifiableList());
                List<String> orderIdsAndMinDate =
                        orderAggregateStateChangeRepository.getOrdersWaitingAggregateStateRefresh(
                                excludeIds, maxResultSize
                        );

                return orderIdsAndMinDate.stream().map(UUID::fromString)
                        .collect(Collectors.toUnmodifiableList());

            }

            @Override
            public long getPendingTasksCount() {
                Set<UUID> excludeIds = getLockedTaskKeys();
                excludeIds = excludeIds == null || excludeIds.isEmpty() ?
                        OrderAggregateStateChangeRepository.NO_EXCLUDE_IDS : excludeIds;
                return orderAggregateStateChangeRepository.countOrdersWaitingAggregateStateRefresh(excludeIds);
            }
        };
        return new TaskProcessor<>(
                taskKeyProvider,
                orderAggregateStateRefresher::refreshOrderAggregateState,
                forcedRollbackTxManagerWrapper,
                TaskProcessorHelper.createDefaultTxDefinition("refreshOrderAggregateState"),
                orderAggregateStateRefreshConfigurationProperties.getTaskProcessor()
        );
    }

}
