package ru.yandex.travel.orders.services.orders.updates;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.kikimr.persqueue.LogbrokerClientFactory;
import ru.yandex.kikimr.persqueue.proxy.ProxyBalancer;

@Configuration
@RequiredArgsConstructor
@EnableConfigurationProperties(OrdersUpdatesQueueProducerConfigurationProperties.class)
public class OrdersUpdatesQueueProducerConfiguration {
    private final OrdersUpdatesQueueProducerConfigurationProperties properties;

    @Bean
    public OrdersUpdatesQueueProducerFactory ordersUpdatesQueueProducerFactory(
            @Qualifier("LogbrokerClientFactory") LogbrokerClientFactory logbrokerClientFactory) {
        if (properties.isMock()) {
            return OrdersUpdatesQueueProducerMock::new;
        }
        return () -> new OrdersUpdatesQueueProducerImpl(logbrokerClientFactory, properties);
    }

    @Bean("LogbrokerClientFactory")
    public LogbrokerClientFactory logbrokerClientFactory() {
        return new LogbrokerClientFactory(new ProxyBalancer(
                properties.getHost(),
                properties.getPort()));
    }
}
