package ru.yandex.travel.orders.services.orders.updates;

import java.time.Duration;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "orders-updates-queue-producer", ignoreUnknownFields = false)
@Validated
@Getter
@Setter
public class OrdersUpdatesQueueProducerConfigurationProperties {
    private boolean mock;

    private String oauthToken;
    private String host;
    private int port;

    private String topic;
    private Duration initTimeout;
    private Duration writeTimeout;
}
