package ru.yandex.travel.orders.services.payments;

import java.math.BigDecimal;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.PositiveOrZero;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Data
@Validated
@ConfigurationProperties(prefix = "trust-payment-policy", ignoreUnknownFields = false)
public class TrustPaymentPolicyProperties {

    @NotNull
    @Valid
    private HotelProperties hotels;

    @NotNull
    @Valid
    private TrainProperties trains;

    @Data
    @Validated
    public static class HotelProperties {
        private boolean forceEnableThreeDs = false;
        private boolean forceDisableThreeDs = false;

        @Valid
        private NoThreeDsProperties noThreeDs;

        @Data
        @Validated
        public static class NoThreeDsProperties {
            @PositiveOrZero
            private int daysBeforeCheckin;
            @PositiveOrZero
            private int daysBeforePenalty;
            @NotNull
            private BigDecimal maxPrice;
        }

    }

    @Data
    @Validated
    public static class TrainProperties {
        private boolean processThroughYt;
    }
}
